<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Channel Config</title>
<link rel="stylesheet" type="text/css" href="../style/default.css" />
<script type="text/javascript" src="../js/jquery-1.8.3.min.js"></script>
<script type="text/javascript" src="../js/smsx_common.js"></script>
<script type="text/javascript" src="../js/card_ch_config.js"></script>
<style type="text/css">
.body_width
{
	width: 500px;
}
.tab_width
{
	width: 480px;
}
.tableContainer input
{
	width: 98%;
	width: 97%\9;
	text-align: center;
}
.tableContainer select
{
	width: 100px;
}
</style>
</head>

<body>
<input type="hidden" id="language" value="0" />
<div class="body_div body_width">
  <div class="table_tab_div">
    <div class="table_tab_left"></div>
    <div class="table_tab tab_width">Channel Configuration</div>
    <div class="table_tab_right"></div>
  </div>
  <div class="tableContainer">
    <table cellpadding="0" cellspacing="0" style="width:100%;" id="ch_config_table">
      <tbody>
        <tr>
          <th width="240px;">Channel</th>
          <td id="channel" title="Channel being configured" style="border-top:0"></td>
        </tr>
        <tr>
          <th>Frequency(MHz)</th>
          <td id="centre_freq" title="Range: 48 to 996"></td>
        </tr>
        <tr>
          <th>Modulation</th>
          <td>
            <select id="modulation" tabindex="1" title="Modulation for the channel" onchange="ModulationChange(this);">
            </select>
          </td>
        </tr>
        <tr>
          <th>Symbol Rate(Mbaud)</th>
          <td>
            <input id="symbol_rate" type="text" tabindex="2" title="Symbol rate for the channel(ITU-A: 3.500-7.000)" onkeyup ="EnableApply();" onchange="SymbolRateChange(this)" />
          </td>
        </tr>
        <tr>
          <th>Bandwidth</th>
          <td>
            <select id="bandwidth" tabindex="3" title="Bandwidth for the channel" onchange="BWChange(this);">
              <option value="8">8</option>
              <option value="6">6</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>Interleaving</th>
          <td>
            <select id="interleaving" title="Interleaving for the channel" onchange="interleavingChange(this);">
              <option value="1">128,1</option>
              <option value="2">128,2</option>
              <option value="3">64,2</option>
              <option value="4">128,3</option>
              <option value="5">32,4</option>
              <option value="6">128,4</option>
              <option value="7">16,8</option>
              <option value="8">128,5</option>
              <option value="9">8,16</option>
              <option value="10">128,6</option>
              <option value="12">128,7</option>
              <option value="14">128,8</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>Channel Mode</th>
          <td>
            <select id="channel_mode" tabindex="3" title="The signal format for the channel" onchange="ModeChange(this);">
              <option value="1">Normal</option>
              <option value="4">Spec_inv</option>
              <option value="0">Mute</option>
              <option value="2">Carrier Wave</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>Transport Stream ID</th>
          <td>
            <input id="transport_id" type="text" tabindex="4" maxlength="5" title="Transport stream identifier for the channel(0 to 65535)" onkeyup="EnableApply();" onchange="TansportIdChange(this)" />
          </td>
        </tr>
        <tr>
          <th>Service Manager</th>
          <td>
            <select id="qam_manager" tabindex="6" title="Manager for the channel" onchange="ManagerChange(this);">
              <option value="0">VOD</option>
              <option value="1">Broadcast</option>
              <option value="2">S_VOD</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>Group Name</th>
          <td>
            <input id="qam_group_name" type="text" tabindex="7" maxlength="20" title="Group name for the channel" onkeyup="EnableApply();" onchange="GroupNameChange(this)" />
          </td>
        </tr>
        <tr>
          <th>Atten</th>
          <td>
            <input id="atten" type="text" tabindex="8" maxlength="6" title="Atten for the channel(0 to 65)" onkeyup="EnableApply();" onchange="AttenChange(this)" />
          </td>
        </tr>
        <tr>
          <th>DTS Adjust</th>
          <td>
            <select id="dts_adjust" tabindex="9" title="DTS adjust for the channel" onchange="DtsAdjustChange(this);">
              <option value="1">Enabled</option>
              <option value="0">Disabled</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>SDV</th>
          <td>
            <select id="sdv_support" tabindex="10" title="SDV support for the channel" onchange="SdvSupportChange(this);">
              <option value="1">Yes</option>
              <option value="0">No</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>Starting UDP Port</th>
          <td>
            <input id="starting_udp_port" type="text" tabindex="11" maxlength="5" title="Starting UDP Port for the channel(0 to 65535)" onkeyup="EnableApply();" onchange="StartUdpPortChange(this)" />
          </td>
        </tr>
      </tbody>
    </table>
  </div>
  <div id="psiInterval" style="display: none;">
    <div class="table_tab_div">
      <div class="table_tab_left"></div>
      <div class="table_tab tab_width">Channel PSI/SI Interval</div>
      <div class="table_tab_right"></div>
    </div>
    <div class="button_div">
      <div class="button_area">
        <input type="button" value="Clear" id="Clear" onclick="goClear();this.style.background = 'url(../images/btn2_normal.png)';"
			hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
        <input type="button" value="Default" id="Default" onclick="goDefault();this.style.background = 'url(../images/btn2_normal.png)';"
			hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
      </div>
    </div>
    <div class="tableContainer">
      <table cellpadding="0" cellspacing="0" style="width:100%;">
        <tr>
          <th width="240px;">PAT Interval(ms)</th>
          <td style="border-top:0">
            <input id="pat_interval" type="text" tabindex="12" maxlength="5" size="15" title="PAT interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 0)" />
          </td>
        </tr>
        <tr>
          <th>PMT Interval(ms)</th>
          <td>
            <input id="pmt_interval" type="text" tabindex="13" maxlength="5" size="15" title="PMT interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 1)" />
          </td>
        </tr>
        <tr>
          <th>NIT_C Interval(ms)</th>
          <td>
            <input id="nit_c_interval" type="text" tabindex="14" maxlength="5" size="15" title="NIT_current interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 2)" />
          </td>
        </tr>
        <tr>
          <th>NIT_O Interval(ms)</th>
          <td>
            <input id="nit_o_interval" type="text" tabindex="15" maxlength="5" size="15" title="NIT_other interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 3)" />
          </td>
        </tr>
        <tr>
          <th>SDT_C Interval(ms)</th>
          <td>
            <input id="sdt_c_interval" type="text" tabindex="16" maxlength="5" size="15" title="SDT_current interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 4)" />
          </td>
        </tr>
        <tr>
          <th>SDT_O Interval(ms)</th>
          <td>
            <input id="sdt_o_interval" type="text" tabindex="17" maxlength="5" size="15" title="SDT_other interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 5)" />
          </td>
        </tr>
        <tr>
          <th>BAT Interval(ms)</th>
          <td>
            <input id="bat_interval" type="text" tabindex="18" maxlength="5" size="15" title="BAT interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 6)" />
          </td>
        </tr>
        <tr>
          <th>CAT Interval(ms)</th>
          <td>
            <input id="cat_interval" type="text" tabindex="19" maxlength="5" size="15" title="CAT interval for the channel" onkeyup ="EnableApply();" onchange="IntervalChange(this, 7)" />
          </td>
        </tr>
      </table>
    </div>
  </div>
  <div class="button">
    <input type="button" style="margin-left:176px;" value="Apply" id="Apply" onclick="QamChannelApply();this.style.background = 'url(../images/btn2_normal.png)';"
		hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
    <input type="button" style="margin-left:8px;" value="Refresh" id="Reset" onclick="QamChannelReload();this.style.background = 'url(../images/btn2_normal.png)';" 
		hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
  </div>
</div>
</body>
</html>